/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpeedometerItem
extends Item {
    public SpeedometerItem(Item.Properties properties) {
        super(properties);
    }

    private static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity2, Hand hand) {
        if (player.field_70170_p.field_72995_K) {
            this.calculateSpeed(player, (Entity)entity2);
        }
        return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
    }

    private void calculateSpeed(PlayerEntity player, Entity entity2) {
        double speed = SpeedometerItem.getBPS(entity2);
        double s = SpeedometerItem.roundToSignificantFigures(speed, 3);
        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.supplementaries.speedometer", new Object[]{s}), true);
    }

    private static double getBPS(Entity entity2) {
        Entity mount = entity2.func_184187_bx();
        Entity e = entity2;
        if (mount != null) {
            e = mount;
        }
        Vector3d v = e.func_213322_ci();
        if (e.func_233570_aj_()) {
            v = v.func_178786_a(0.0, v.field_72448_b, 0.0);
        }
        return v.func_72433_c() * 20.0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            this.calculateSpeed(player, (Entity)player);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public static class SpeedometerItemProperty
    implements IItemPropertyGetter {
        public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity player) {
            LivingEntity entity2;
            Object object = entity2 = player != null ? player : stack.func_234694_A_();
            if (entity2 == null) {
                return 0.0f;
            }
            double speed = SpeedometerItem.getBPS((Entity)entity2);
            double max = 60.0;
            return (float)Math.min(speed / max, 1.0);
        }
    }
}

